//
//  ViewController.swift
//  PhoneAppExample
//
//  Created by Ole Helgesen on 24/06/2022.
//

import UIKit
import EaseLiveSDK

class ViewController: UIViewController {
    let accountId = "demo"
    
    var easeLive: EaseLive? = nil
    @IBOutlet weak var infoLabel: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }

    func loadEaseLive(programId: String, syncId: String) {
        infoLabel.isHidden = true
        
        easeLive?.destroy()
        
        EaseLive.setDebugging(debug: true)
        
        // setup EL with the programId and syncId parameters passed from the scanned QR code (see SceneDelegate)
        
        self.easeLive = EaseLive(parentView: self.view,
                                 accountId: accountId,
                                 projectId: nil,
                                 programId: programId,
                                 env: "staging",
                                 params: [
                                    "syncId": syncId
                                 ],
                                 playerPlugin: nil)
        self.easeLive?.create()
        self.easeLive?.load()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        
        if isBeingDismissed {
            easeLive?.destroy()
        }
    }
}
